/*
 * Copyright (C) 2018-2019 Roumen Petrov.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.openmolcas_arm;

import android.content.SharedPreferences;
import android.content.res.AssetManager;

import com.openmolcas_arm.utils.ThemeManager;

import androidx.preference.PreferenceManager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

import android.os.Handler;


public class Application extends android.app.Application {
    public static final String ID = BuildConfig.APPLICATION_ID;

    /**
     * The tag we use when logging, so that our messages can be distinguished
     * from other messages in the log. Public because it's used by several
     * classes.
     */
    public static final String APP_TAG = "OPENMOLCAS";

    public static final String ACTION_OPEN_NEW_WINDOW = "com.openmolcas_arm.OPEN_NEW_WINDOW";
    public static final String ACTION_SWITCH_WINDOW = "com.openmolcas_arm.SWITCH_WINDOW";
    public static final String ACTION_RUN_SHORTCUT = "com.openmolcas_arm.RUN_SHORTCUT";
    public static final String ACTION_RUN_SCRIPT = "com.openmolcas_arm.RUN_SCRIPT";

    public static final String ARGUMENT_TARGET_WINDOW = "target_window";
    public static final String ARGUMENT_WINDOW_ID = "window_id";
    /* arguments for use by external applications */
    public static final String ARGUMENT_SHELL_COMMAND = "com.openmolcas_arm.Command";
    public static final String ARGUMENT_WINDOW_HANDLE = "com.openmolcas_arm.WindowHandle";

    private Handler handler = new Handler();

    @Override
    public void onCreate() {
        super.onCreate();
        copyAsset("system.zip");
        copyAsset2("busybox");
        copyAsset3("README.pdf");
        copyAsset3("LICENSE_NOTE-BUSYBOX.txt");
        copyAsset3("LICENSE-ADVANCED_INSTALLER.txt");
        copyAsset3("LICENSE-BUSYBOX.txt");
        copyAsset3("LICENSE-CRYSTAX_NDK.txt");
        copyAsset3("LICENSE-CYGWIN.txt");
        copyAsset3("LICENSE-CYGWIN_API.txt");
        copyAsset3("LICENSE-LAPACK.txt");
        copyAsset3("LICENSE-LIBSDL.txt");
        copyAsset3("LICENSE-OPENMOLCAS.txt");
        copyAsset3("LICENSE-PYTHON.txt");
        copyAsset3("LICENSE-PYTHON-ASYNCHRONOUS_SOCKET_SERVICES.txt");
        copyAsset3("LICENSE-PYTHON-CFUHASH.txt");
        copyAsset3("LICENSE-PYTHON-COOKIE_MANAGEMENT.txt");
        copyAsset3("LICENSE-PYTHON-EXECUTION_TRACING.txt");
        copyAsset3("LICENSE-PYTHON-EXPAT.txt");
        copyAsset3("LICENSE-PYTHON-KQUEUE.txt");
        copyAsset3("LICENSE-PYTHON-LIBFFI.txt");
        copyAsset3("LICENSE-PYTHON-LIBMPDEC.txt");
        copyAsset3("LICENSE-PYTHON-MERSENNE_TWISTER.txt");
        copyAsset3("LICENSE-PYTHON-OPENSSL.txt");
        copyAsset3("LICENSE-PYTHON-PYPARSING.txt");
        copyAsset3("LICENSE-PYTHON-SETUPTOOLS.txt");
        copyAsset3("LICENSE-PYTHON-SIPHASH24.txt");
        copyAsset3("LICENSE-PYTHON-SIX.txt");
        copyAsset3("LICENSE-PYTHON-SOCKETS.txt");
        copyAsset3("LICENSE-PYTHON-STRTOD-DTOA.txt");
        copyAsset3("LICENSE-PYTHON-TEST_EPOLL.txt");
        copyAsset3("LICENSE-PYTHON-UUENCODE_UUDECODE.txt");
        copyAsset3("LICENSE-PYTHON-XML_REMOTE_PROCEDURE_CALLS.txt");
        copyAsset3("LICENSE-PYTHON-ZLIB.txt");
        copyAsset3("LICENSE-TERMONEPLUS.txt");
        copyAsset3("LICENSING_TERMS-BLAS.txt");
        copyAsset3("LICENSING_TERMS-BUSYBOX.txt");
        copyAsset3("LICENSING_TERMS-CRYSTAX_NDK.txt");
        copyAsset3("LICENSING_TERMS-CYGWIN.txt");
        copyAsset3("LICENSING_TERMS-LAPACK.txt");
        copyAsset3("LICENSING_TERMS-LIBSDL.txt");
        copyAsset3("LICENSING_TERMS-PYTHON.txt");
        copyAsset3("LICENSING_TERMS-TERMONEPLUS.txt");
        copyAsset3("Manual.txt");
        install_files();



        setupPreferences();
        ThemeManager.migrateFileSelectionThemeMode(this);

    }

    private void copyAsset(String filename) {
        String dirPath = "/data/data/com.openmolcas_arm/system";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            AssetManager assetManager = getAssets();
            InputStream in = null;
            OutputStream out = null;
            try {
                in = assetManager.open(filename);
                File outFile = new File(dirPath, filename);
                out = new FileOutputStream(outFile);
                copyFile(in, out);
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (in != null) {
                    try {
                        in.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            //do nothing
        }
    }

    private void copyAsset2(String filename) {
        String dirPath = "/data/data/com.openmolcas_arm/busybox";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            AssetManager assetManager = getAssets();
            InputStream in = null;
            OutputStream out = null;
            try {
                in = assetManager.open(filename);
                File outFile = new File(dirPath, filename);
                out = new FileOutputStream(outFile);
                copyFile(in, out);
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (in != null) {
                    try {
                        in.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            //do nothing
        }
    }

    private void copyAsset3(String filename) {
        String dirPath = "/mnt/sdcard/openmolcas";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            AssetManager assetManager = getAssets();
            InputStream in = null;
            OutputStream out = null;
            try {
                in = assetManager.open(filename);
                File outFile = new File(dirPath, filename);
                out = new FileOutputStream(outFile);
                copyFile(in, out);
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (in != null) {
                    try {
                        in.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            //do nothing
        }
    }

    private void copyFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read;
        while ((read = in.read(buffer)) != -1){
            out.write(buffer, 0, read);
        }
    }

    private void install_files() {
        // TODO Auto-generated method stub //
                    try {
                        // Some code........
                        exec("chmod 755 /data/data/com.openmolcas_arm/busybox/busybox");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/system.zip");
                        exec("/data/data/com.openmolcas_arm/busybox/busybox unzip /data/data/com.openmolcas_arm/system/system.zip -d /data/data/com.openmolcas_arm/system");
                        exec("mv /data/data/com.openmolcas_arm/busybox/busybox /data/data/com.openmolcas_arm/system/bin");
                        exec("rm /data/data/com.openmolcas_arm/system/system.zip");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pymolcas");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/adjtimex");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ar");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/arch");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/arp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/arping");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ash");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/awk");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/base64");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/basename");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/bbconfig");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/blkdiscard");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/blkid");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/blockdev");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/brctl");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/bunzip2");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/bzcat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/bzip2");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cal");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chattr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chgrp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chmod");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chown");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chroot");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/chrt");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cksum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/clear");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cmp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/comm");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cpio");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/cut");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/date");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/devmem");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/df");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/diff");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dirname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dmesg");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dnsd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dnsdomainname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dos2unix");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dpkg");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dpkg-deb");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/dt");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/du");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/echo");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ed");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/egrep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/eject");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/env");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ether-wake");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/expand");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/expr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/factor");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/false");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fatattr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fbset");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fdisk");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fgrep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/find");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/findfs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/flashcp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/flash_eraseall");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/flash_lock");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/flash_unlock");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/flock");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fold");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/free");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/freeramdisk");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fsck");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fsfreeze");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fstrim");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fsync");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ftpd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ftpget");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ftpput");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/fuser");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/getopt");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/grep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/groups");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/gunzip");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/gzip");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hdparm");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/head");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hexdump");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hexedit");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hostname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/httpd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/hwclock");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/i2cdetect");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/i2cdump");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/i2cget");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/i2cset");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/id");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ifconfig");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/inetd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/insmod");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/install");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ionice");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/iostat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ip");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ipaddr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ipcalc");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/iplink");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ipneigh");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/iproute");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/iprule");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/iptunnel");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/kill");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/killall");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/killall5");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/less");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/link");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ln");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/logname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/losetup");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ls");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lsattr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lsmod");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lsof");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lspci");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lsscsi");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lsusb");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lzcat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lzop");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/lzopcat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/makedevs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/man");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/md5sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/microcom");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mkdir");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mkdosfs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mke2fs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mkfifo");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mknod");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mkswap");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mktemp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/modinfo");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/modprobe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/more");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mount");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mountpoint");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mpstat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/mv");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nanddump");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nandwrite");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nbd-client");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nc");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/netstat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nice");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nl");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nmeter");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nohup");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nologin");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/nproc");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ntpd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/od");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/partprobe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/paste");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/patch");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pgrep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pidof");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ping");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ping6");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pipe_progress");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pivot_root");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pkill");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pmap");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/powertop");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/printenv");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/printf");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ps");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pscan");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pstree");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pwd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pwdx");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/pymolcas");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rdate");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rdev");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/readlink");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/realpath");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/renice");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/reset");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/resize");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rev");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rfkill");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rm");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rmdir");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rmmod");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/route");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rpm2cpio");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rtcwake");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/run-init");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/run-parts");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/rx");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/script");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/scriptreplay");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sed");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/seq");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/setfattr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/setpriv");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/setserial");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/setsid");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sh");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sha1sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sha3sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sha256sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sha512sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/shred");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/shuf");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sleep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/smemcap");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sort");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/split");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ssl_client");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/stat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/strings");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/stty");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sum");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/swapoff");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/swapon");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/switch_root");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sync");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/sysctl");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tac");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tail");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tar");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tc");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tcpsvd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tee");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/telnet");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/telnetd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/test");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tftp");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tftpd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/time");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/timeout");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/top");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/touch");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tr");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/traceroute");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/traceroute6");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/true");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/truncate");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tty");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/ttysize");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tunctl");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/tune2fs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/udpsvd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uevent");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/umount");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uncompress");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unexpand");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uniq");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unix2dos");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unlink");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unlzma");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unlzop");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unxz");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/unzip");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uptime");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/usleep");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uudecode");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/uuencode");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/vconfig");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/vi");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/volname");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/watch");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/wc");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/wget");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/which");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/whoami");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/whois");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/xargs");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/xxd");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/xz");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/xzcat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/yes");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/zcat");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/[");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/bin/[[");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/easy_install");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/easy_install-3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/idle3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/pydoc3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/python3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/python3.7-config");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/pyvenv-3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/python/bin/2to3-3.7");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/alaska.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/averd.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/caspt2.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/casvb.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/ccsdt.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/chcc.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/cht3.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/cpf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/dynamix.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/espf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/expbas.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/extf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/ffpt.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/gateway.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/genano.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/guessorb.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/guga.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/gugaci.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/gugadrt.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/last_energy.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/localisation.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/loprop.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mbpt2.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mckinley.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mclr.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mcpdft.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/motra.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mpprop.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/mrci.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/numerical_gradient.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/parnell.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/poly_aniso.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/qmstat.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/quater.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/rasscf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/rassi.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/rpa.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/scf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/seward.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/single_aniso.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/slapaf.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/surfacehop.exe");
                        exec("chmod 755 /data/data/com.openmolcas_arm/system/molcas/bin/vibrot.exe");
                        exec("rmdir /data/data/com.openmolcas_arm/busybox");
                        exec("mkdir /data/data/com.openmolcas_arm/tmp");
                    } catch (Exception e) {
                    }
                }
                // Executes UNIX command.
                private String exec(String command) {
                    try {
                        java.lang.Process process3 = Runtime.getRuntime().exec(command);
                        BufferedReader reader = new BufferedReader(
                                new InputStreamReader(process3.getInputStream()));
                        int read;
                        char[] buffer = new char[4096];
                        StringBuffer output = new StringBuffer();
                        while ((read = reader.read(buffer)) > 0) {
                            output.append(buffer, 0, read);
                        }
                        reader.close();
                        process3.waitFor();
                        return output.toString();
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }

    private void setupPreferences() {
        boolean updated = false;

        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();

        if (!prefs.contains("home_path")) {
            String path = getDir("HOME", MODE_PRIVATE).getAbsolutePath();
            editor.putString("home_path", path);
            updated = true;
        }
        // remove obsolete preferences:
        // - after v3.0.0, TODO remove string resources in next major
        if (prefs.contains("allow_prepend_path")) {
            // Note depends from do_path_extensions
            editor.remove("allow_prepend_path");
            updated = true;
        }
        if (prefs.contains("do_path_extensions")) {
            editor.remove("do_path_extensions");
            updated = true;
        }

        if (updated) editor.apply();
    }
}
